/*
 * Decompiled with CFR 0.152.
 */
package com.protomatter.iriver.data;

import java.io.IOException;
import java.io.OutputStream;

public class DataUtil {
    private static final String CHARSET = "US-ASCII";

    public static final void pad(OutputStream outputStream, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            outputStream.write(0);
            ++n2;
        }
    }

    public static final void writeString(OutputStream outputStream, String string) throws IOException {
        DataUtil.writeString(outputStream, string, string.length());
    }

    public static final void writeString(OutputStream outputStream, String string, int n) throws IOException {
        outputStream.write(string.getBytes(CHARSET));
        DataUtil.pad(outputStream, n - string.length());
    }

    public static final byte[] getBytes(short s) {
        byte[] byArray = new byte[2];
        int n = 0;
        int n2 = 8;
        while (n < 2) {
            byArray[1 - n] = (byte)(0xFF & s >> n2);
            ++n;
            n2 -= 8;
        }
        return byArray;
    }

    public static final byte[] getBytes(int n) {
        byte[] byArray = new byte[4];
        int n2 = 0;
        int n3 = 24;
        while (n2 < 4) {
            byArray[3 - n2] = (byte)(0xFF & n >> n3);
            ++n2;
            n3 -= 8;
        }
        return byArray;
    }
}

