/*
 * Decompiled with CFR 0.152.
 */
package com.protomatter.iriver;

import com.protomatter.iriver.data.AudioFileDescriptor;
import com.protomatter.iriver.data.DBUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class CreateDatabase {
    private static final String UNKNOWN = "Unknown";
    private static final boolean verbose = false;
    private static DecimalFormat intformat = new DecimalFormat("###,###,###,##0");
    private static DecimalFormat numformat = new DecimalFormat("###,###,###,##0.00");

    private static List getFiles(String string) throws Exception {
        LinkedList linkedList = new LinkedList();
        File file = new File(string);
        CreateDatabase.addFiles(linkedList, file.getAbsolutePath().length() + 1, file);
        return linkedList;
    }

    private static AudioFileDescriptor getOggInfo(File file, String string) throws Exception {
        System.out.println("Loading " + file.getPath());
        Process process = Runtime.getRuntime().exec(new String[]{"oggtst", file.getAbsolutePath()});
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String string2 = UNKNOWN;
        String string3 = UNKNOWN;
        String string4 = UNKNOWN;
        String string5 = UNKNOWN;
        String string6 = null;
        while ((string6 = bufferedReader.readLine()) != null) {
            if (string6.startsWith("title=")) {
                string3 = string6.substring(string6.indexOf("=") + 1).trim();
                continue;
            }
            if (string6.startsWith("artist=")) {
                string4 = string6.substring(string6.indexOf("=") + 1).trim();
                continue;
            }
            if (string6.startsWith("album=")) {
                string2 = string6.substring(string6.indexOf("=") + 1).trim();
                continue;
            }
            if (!string6.startsWith("genre=")) continue;
            string5 = string6.substring(string6.indexOf("=") + 1).trim();
        }
        process.waitFor();
        if (UNKNOWN.equals(string3) && UNKNOWN.equals(string4) && UNKNOWN.equals(string2) && UNKNOWN.equals(string5)) {
            System.err.println("DOH!!!  Something has gone wrong.  Can't get info from this file");
            System.exit(1);
        }
        AudioFileDescriptor audioFileDescriptor = new AudioFileDescriptor(string, string2, string3, string4, string5);
        return audioFileDescriptor;
    }

    private static void addFiles(List list, int n, File file) throws Exception {
        Object[] objectArray = file.listFiles();
        Arrays.sort(objectArray);
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (((File)objectArray[n2]).isDirectory()) {
                CreateDatabase.addFiles(list, n, (File)objectArray[n2]);
            } else {
                String string = ((File)objectArray[n2]).getAbsolutePath().substring(n);
                if (string.endsWith(".ogg")) {
                    list.add(CreateDatabase.getOggInfo((File)objectArray[n2], "\\" + string.replace('/', '\\')));
                }
            }
            ++n2;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.out.println("Usage: CreateDatabase basedir iriverdatabase");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        try {
            System.out.println("Loading files from " + string);
            long l = System.currentTimeMillis();
            List list = CreateDatabase.getFiles(string);
            l = System.currentTimeMillis() - l;
            System.out.println("Loaded " + intformat.format(list.size()) + " files in " + numformat.format((double)l / 1000.0) + "s");
            File file = new File(string2);
            DBUtil.writeDatabase(file, list);
            System.out.println("Wrote " + numformat.format((double)file.length() / 1024.0) + " KB to " + file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

