/*
 * Decompiled with CFR 0.152.
 */
package com.protomatter.iriver;

import com.protomatter.iriver.data.AudioFileDescriptor;
import com.protomatter.iriver.data.RBDatabase;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class ConvertRhythmboxPlaylist {
    private static DecimalFormat intformat = new DecimalFormat("###,###,###,##0");
    private static DecimalFormat numformat = new DecimalFormat("###,###,###,##0.00");

    public static void main(String[] stringArray) {
        if (stringArray.length != 4) {
            System.out.println("Usage: ConvertRhythmboxDatabase rhythmboxdb rhythmboxplaylist basedir outputplaylist");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        try {
            System.out.println("Parsing rhythmbox database " + string);
            long l = System.currentTimeMillis();
            RBDatabase rBDatabase = new RBDatabase(new File(string), string3, false);
            Map map = rBDatabase.getNodeMap();
            l = System.currentTimeMillis() - l;
            System.out.println("Loaded " + intformat.format(map.size()) + " files in " + numformat.format((double)l / 1000.0) + "s");
            PrintWriter printWriter = new PrintWriter(new FileWriter(new File(string4)));
            System.out.println("Parsing rhythmbox playlist " + string2);
            l = System.currentTimeMillis();
            SAXBuilder sAXBuilder = new SAXBuilder();
            Document document = sAXBuilder.build(new File(string2));
            Element element = document.getRootElement();
            Iterator iterator = element.getChildren("node_pointer").iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                String string5 = element2.getAttributeValue("id");
                AudioFileDescriptor audioFileDescriptor = (AudioFileDescriptor)map.get(string5);
                if (audioFileDescriptor == null) {
                    System.out.println("Can't find node referece for ID=" + string5);
                    System.out.println("Can't convert this playlist.... maybe it references files");
                    System.out.println("from another rhythmbox database?");
                    System.exit(1);
                    continue;
                }
                printWriter.println(audioFileDescriptor.getFileName());
                ++n;
            }
            printWriter.flush();
            printWriter.close();
            l = System.currentTimeMillis() - l;
            System.out.println("Read and converted " + intformat.format(n) + " playlist entries in " + numformat.format((double)l / 1000.0) + "s");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

