/*
 * Decompiled with CFR 0.152.
 */
package com.protomatter.iriver;

import com.protomatter.iriver.data.DBUtil;
import com.protomatter.iriver.data.RBDatabase;
import java.io.File;
import java.text.DecimalFormat;
import java.util.List;

public class ConvertRhythmboxDatabase {
    private static DecimalFormat intformat = new DecimalFormat("###,###,###,##0");
    private static DecimalFormat numformat = new DecimalFormat("###,###,###,##0.00");

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            System.out.println("Usage: ConvertRhythmboxDatabase rhythmboxdb basedir iriverdatabase");
            System.out.println("  Converts \"rhytmboxdb\" into \"iriverdatabase\"");
            System.out.println("  \"basedir\" should be the base directory of the iriver unit");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        try {
            System.out.println("Parsing rhythmbox database " + string);
            long l = System.currentTimeMillis();
            RBDatabase rBDatabase = new RBDatabase(new File(string), string2, true);
            List list = rBDatabase.getDescriptors();
            l = System.currentTimeMillis() - l;
            System.out.println("Loaded " + intformat.format(list.size()) + " files in " + numformat.format((double)l / 1000.0) + "s");
            File file = new File(string3);
            DBUtil.writeDatabase(file, list);
            System.out.println("Wrote " + numformat.format((double)file.length() / 1024.0) + " KB to " + file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

