package com.protomatter.iriver.data;

import java.io.*;
import java.net.*;
import java.util.*;

import org.jdom.*;
import org.jdom.output.*;
import org.jdom.input.*;

public class RBDatabase
{
    public static final String TRACK_NAME_ID = "0";
    public static final String FILE_NAME_ID = "12";
    public static final String GENRE_ID = "2";
    public static final String ARTIST_ID = "3";
    public static final String ALBUM_ID = "4";
    public static final String ID = "id";
    public static final String PROPERTY = "property";
    public static final String NODE = "node";
    public static final String NODE_POINTER = "node_pointer";
    
    private List descriptors = new LinkedList();
    private Map nodeMap = new HashMap();
    
    public RBDatabase(File dbFile, String baseDir, boolean verboseLoad)
    throws Exception
    {
        SAXBuilder builder = new SAXBuilder();
        Document document = builder.build(dbFile);
        Element root = document.getRootElement();
        
        Iterator it = root.getChildren(NODE).iterator();
        while (it.hasNext())
        {
            Element e = (Element)it.next();
            String nodeId = e.getAttributeValue(ID);
            
            Iterator properties = e.getChildren(PROPERTY).iterator();
            
            String trackName = null;
            String artist = null;
            String genre = null;
            String album = null;
            String fileName = null;
            
            while (properties.hasNext())
            {
                Element prop = (Element)properties.next();
                String id = prop.getAttributeValue(ID);
                
                if (TRACK_NAME_ID.equals(id))
                {
                    trackName = prop.getText();
                }
                else if (FILE_NAME_ID.equals(id))
                {
                    fileName = prop.getText();
                }
                else if (GENRE_ID.equals(id))
                {
                    genre = prop.getText();
                }
                else if (ARTIST_ID.equals(id))
                {
                    artist = prop.getText();
                }
                else if (ALBUM_ID.equals(id))
                {
                    album = prop.getText();
                }
            }
            
            if ((fileName != null) &&
                (trackName != null) &&
                (genre != null) &&
                (artist != null) &&
                (album != null))
            {
                URL url = new URL(fileName);
                fileName = url.getPath();
                if (verboseLoad)
                {
                    System.out.println("Loading " + fileName);
                }

                if (fileName.startsWith(baseDir))
                {
                    fileName = fileName.substring(baseDir.length());
                }
                fileName = fileName.replace('/', '\\'); // sigh
                
                AudioFileDescriptor fd = new AudioFileDescriptor(fileName, album, trackName, artist, genre);
                descriptors.add(fd);
                nodeMap.put(nodeId, fd);
            }
        }
    }
    
    public List getDescriptors()
    {
        return this.descriptors;
    }
    
    public Map getNodeMap()
    {
        return this.nodeMap;
    }
}