package com.protomatter.iriver.data;

import java.io.*;

public class DataUtil
{
    private static final String CHARSET = "US-ASCII";
    
    public static final void pad(OutputStream out, int size)
    throws IOException
    {
        for (int i=0; i<size; i++)
            out.write((int)0);
    }
    
    public static final void writeString(OutputStream out, String s)
    throws IOException
    {
        writeString(out, s, s.length());
    }
    
    public static final void writeString(OutputStream out, String s, int length)
    throws IOException
    {
        out.write(s.getBytes(CHARSET));
        pad(out, (length - s.length()));
    }
    
    public static final byte[] getBytes(short v)
    {
        byte b[] = new byte[2];
        int i, shift;
        
        for(i = 0, shift = 8; i < 2; i++, shift -= 8)
            b[1-i] = (byte)(0xFF & (v >> shift));
        
        //System.out.println("getBytes(" + v + ") == [" + b[0] + "][" + b[1] + "]");

        return b;
    }
    
    public static final byte[] getBytes(int v)
    {
        byte b[] = new byte[4];
        int i, shift;
        
        for(i = 0, shift = 24; i < 4; i++, shift -= 8)
            b[3-i] = (byte)(0xFF & (v >> shift));
        
        //System.out.println("getBytes(" + v + ") == [" + b[0] + "][" + b[1] + "][" + b[2] + "][" + b[3] + "]");

        return b;
    }
}