package com.protomatter.iriver.data;

import java.io.*;
import java.util.*;

import com.protomatter.util.*;

public class DBUtil
{
    public static void writeDatabase(File databaseFile, List descriptors)
    throws Exception
    {
        ByteArrayOutputStream header = new ByteArrayOutputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream fat = new ByteArrayOutputStream();
        

        // header cluster - 64 bytes
        DataUtil.writeString(header, "iRivDB Ver 0.12", 32);
        DataUtil.writeString(header, "iRiver iHP-100 DB File", 32);
        
        // num files cluster - 64 bytes
        header.write(DataUtil.getBytes((int)descriptors.size()));
        DataUtil.pad(header, 60);


        // write file info
        Iterator it = descriptors.iterator();
        int currentBlockSize = 0;
        int currentOffset = 0;
        int fatPadSize = 0;
        int fatUsed = 0;
        while (it.hasNext())
        {
            // write the offset of this file's info to the FAT
            fat.write(DataUtil.getBytes(currentOffset));
            fatPadSize += 4;
            fatPadSize = fatPadSize % 64;
            fatUsed += 4;
            
            // write this file's info into the data segment
            AudioFileDescriptor fd = (AudioFileDescriptor)it.next();
            currentBlockSize += fd.getDataSize();
            currentBlockSize = currentBlockSize % 64;
            fd.write(out);

            currentOffset += fd.getDataSize();
        }
        //DataUtil.pad(out, (64 - currentBlockSize));
        DataUtil.pad(fat, (64 - fatPadSize));


        // end of FAT cluster
        
        // pad FAT to 41088 bytes (160 bytes extra)
        DataUtil.pad(fat, (41088 - 160 - fatUsed));
        DataUtil.writeString(fat, "Designed by iRiver", 64);
        

        // done writing stuff
        out.flush();
        fat.flush();
        header.flush();
        
        FileOutputStream file = new FileOutputStream(databaseFile);
        file.write(header.toByteArray());
        file.write(fat.toByteArray());
        file.write(out.toByteArray());
        file.close();
        
        //System.out.println(ByteDisplay.displayBytes(header.toByteArray()));
    }
}