package com.protomatter.iriver.data;

import java.io.*;

public class AudioFileDescriptor
{
    private String fileName = null;
    private String trackName = null;
    private String artist = null;
    private String album = null;
    private String genre = null;
    
    public AudioFileDescriptor(String fileName, String album, String trackName, String artist, String genre)
    {
        this.fileName = fileName;
        this.trackName = trackName;
        this.album = album;
        this.artist = artist;
        this.genre = genre;
    }
    
    public String getFileName()
    {
        return this.fileName;
    }
    
    public String getAlbum()
    {
        return this.album;
    }
    
    public String getTrackName()
    {
        return this.trackName;
    }
    
    public String getArtist()
    {
        return this.artist;
    }
    
    public String getGenre()
    {
        return this.genre;
    }
    
    public void write(OutputStream out)
    throws IOException
    {
        // write the iRiver packed representation of this file
        
        // these lengths include the extra 0 byte at the end.
        
        // file name length - 2 bytes
        out.write(DataUtil.getBytes((short) (fileName.length() +1)));

        // track name length - 2 bytes
        out.write(DataUtil.getBytes((short) (trackName.length() +1)));

        // artist length - 2 bytes
        out.write(DataUtil.getBytes((short) (artist.length() +1)));

        // disc title length - 2 bytes
        out.write(DataUtil.getBytes((short) (album.length() +1)));

        // genre length - 2 bytes
        out.write(DataUtil.getBytes((short) (genre.length() +1)));
        

        // filename + null
        DataUtil.writeString(out, fileName);
        out.write((int)0);
        
        // track name + null
        DataUtil.writeString(out, trackName);
        out.write((int)0);
        
        // artist name + null
        DataUtil.writeString(out, artist);
        out.write((int)0);
        
        // disc title + null
        DataUtil.writeString(out, album);
        out.write((int)0);
        
        // genre + null
        DataUtil.writeString(out, genre);
        out.write((int)0);
   }
    
    public int getDataSize()
    {
        // get the total data size for this file's packed representation
        
        return 15 // 10 bytes of sizes, plus 5 null bytes
            + fileName.length()
            + trackName.length()
            + artist.length()
            + album.length()
            + genre.length();
    }
}