package com.protomatter.iriver;

import java.io.*;
import java.util.*;
import java.text.*;

import com.protomatter.iriver.data.*;

public class Main
{
    public static void main(String args[])
    {
        if ((args.length == 0) ||
            ((args.length == 1) && ("--help".equalsIgnoreCase(args[0]))))
        {
            usage();
        }
        
        if ("createdb".equalsIgnoreCase(args[0]))
        {
            if (args.length != 3)
            {
                usage();
            }
            CreateDatabase.main(new String[] { args[1], args[2] });
        }
        else if ("convertdb".equalsIgnoreCase(args[0]))
        {
            if (args.length != 4)
            {
                usage();
            }
            ConvertRhythmboxDatabase.main(new String[] { args[1], args[2], args[3] });
        }
        else if ("convertpl".equalsIgnoreCase(args[0]))
        {
            if (args.length != 5)
            {
                usage();
            }
            ConvertRhythmboxPlaylist.main(new String[] { args[1], args[2], args[3], args[4] });
        }
        else
        {
            usage();
        }
    }
    
    private static void usage()
    {
        System.out.println("Usage:");
        System.out.println("  To create a new iRiver database from files:");
        System.out.println("      java -jar iRiverDatabaseUtil.jar createdb basedir iriverdatabase");
        System.out.println("");
        System.out.println("  To convert a rhythmbox database to an iRiver database:");
        System.out.println("    java -jar iRiverDatabaseUtil.jar convertdb rhythmboxdb basedir iriverdatabase");
        System.out.println("");
        System.out.println("  To convert a rhythmbox playlist to a winamp (iRiver) playlist:");
        System.out.println("    java -jar iRiverDatabaseUtil.jar convertpl rhythmboxdb rhythmboxplaylist basedir outputplaylist");
        System.out.println("");
        System.exit(1);
    }
}