package com.protomatter.iriver;

import java.io.*;
import java.util.*;
import java.text.*;

import com.protomatter.iriver.data.*;
import com.protomatter.util.*;

public class CreateDatabase
{
    private static final String UNKNOWN = "Unknown";
    
    private static final boolean verbose = false;
    
    private static DecimalFormat intformat = new DecimalFormat("###,###,###,##0");
    private static DecimalFormat numformat = new DecimalFormat("###,###,###,##0.00");
    
    private static List getFiles(String baseDir)
    throws Exception
    {
        List list = new LinkedList();
        File base = new File(baseDir);
        addFiles(list, base.getAbsolutePath().length() +1, base);
        return list;
    }
    
    private static AudioFileDescriptor getOggInfo(File file, String name)
    throws Exception
    {
        // this is a terrible hack.
        // j-ogg lets you read all this info, but it seems to parse the entire file,
        // so it takes a heck of a lot longer.
        
        System.out.println("Loading " + file.getPath());
        
        Process proc = Runtime.getRuntime().exec(new String[] { "oggtst", file.getAbsolutePath() });
        BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));

        String album = UNKNOWN;
        String title = UNKNOWN;
        String artist = UNKNOWN;
        String genre = UNKNOWN;

        String line = null;
        while ((line = reader.readLine()) != null)
        {
            // "title=Juanita/Kiteless"
            // "artist=Underworld"
            // "album=Everything, Everything"
            
            if (line.startsWith("title="))
            {
                title = line.substring(line.indexOf("=") +1).trim();
            }
            else if (line.startsWith("artist="))
            {
                artist = line.substring(line.indexOf("=") +1).trim();
            }
            else if (line.startsWith("album="))
            {
                album = line.substring(line.indexOf("=") +1).trim();
            }
            else if (line.startsWith("genre="))
            {
                genre = line.substring(line.indexOf("=") +1).trim();
            }
        }
        proc.waitFor();
        
        if (UNKNOWN.equals(title) &&
            UNKNOWN.equals(artist) &&
            UNKNOWN.equals(album) &&
            UNKNOWN.equals(genre))
        {
            System.err.println("DOH!!!  Something has gone wrong.  Can't get info from this file");
            System.exit(1);
        }
        
        if (verbose)
        {
            System.out.println("  artist: " + artist);
            System.out.println("  disc:   " + album);
            System.out.println("  track:  " + title);
        }
        
        AudioFileDescriptor fd = new AudioFileDescriptor(name, album, title, artist, genre);
        
        return fd;
    }
    
    private static void addFiles(List list, int baseDirSize, File dir)
    throws Exception
    {
        File files[] = dir.listFiles();
        Arrays.sort(files);
        for (int i=0; i<files.length; i++)
        {
            if (files[i].isDirectory())
            {
                addFiles(list, baseDirSize, files[i]);
            }
            else
            {
                String fileName = files[i].getAbsolutePath().substring(baseDirSize);
                if (fileName.endsWith(".ogg"))
                {
                    list.add(getOggInfo(files[i], "\\" + fileName.replace('/', '\\')));
                }
            }
        }
    }
    
    public static void main(String args[])
    {
        if (args.length != 2)
        {
            System.out.println("Usage: CreateDatabase basedir iriverdatabase");
            System.exit(1);
        }
        
        String baseDir = args[0];
        String databaseName = args[1];
        
        try
        {
            System.out.println("Loading files from " + baseDir);
            long time = System.currentTimeMillis();
            List descriptors = getFiles(baseDir);
            time = System.currentTimeMillis() - time;
            System.out.println("Loaded " + intformat.format(descriptors.size())
                + " files in "
                + numformat.format( ((double)time/(double)1000) ) + "s");
            
            File databaseFile = new File(databaseName);

            DBUtil.writeDatabase(databaseFile, descriptors);

            System.out.println("Wrote " + numformat.format( ((double)databaseFile.length()/(double)1024) )
                + " KB to " + databaseFile);
        }
        catch (Exception x)
        {
            x.printStackTrace();
            System.exit(1);
        }
    }
}