package com.protomatter.iriver;

import java.io.*;
import java.util.*;
import java.text.*;

import java.net.URL;

import com.protomatter.iriver.data.*;

import org.jdom.*;
import org.jdom.output.*;
import org.jdom.input.*;


public class ConvertRhythmboxPlaylist
{
    private static DecimalFormat intformat = new DecimalFormat("###,###,###,##0");
    private static DecimalFormat numformat = new DecimalFormat("###,###,###,##0.00");
    
    public static void main(String args[])
    {
        if (args.length != 4)
        {
            System.out.println("Usage: ConvertRhythmboxDatabase rhythmboxdb rhythmboxplaylist basedir outputplaylist");
            System.exit(1);
        }
        
        String rbDatabase = args[0];
        String playList = args[1];
        String baseDir = args[2];
        String outputPlayList = args[3];
        
        try
        {
            System.out.println("Parsing rhythmbox database " + rbDatabase);
            long time = System.currentTimeMillis();
            RBDatabase db = new RBDatabase(new File(rbDatabase), baseDir, false);
            Map nodeMap = db.getNodeMap();
            time = System.currentTimeMillis() - time;
            System.out.println("Loaded " + intformat.format(nodeMap.size())
                + " files in "
                + numformat.format( ((double)time/(double)1000) ) + "s");
            
                
            // now load the playlist file
            PrintWriter writer = new PrintWriter(new FileWriter(new File(outputPlayList)));

            System.out.println("Parsing rhythmbox playlist " + playList);
            time = System.currentTimeMillis();
            SAXBuilder builder = new SAXBuilder();
            Document document = builder.build(new File(playList));
            Element root = document.getRootElement();
            Iterator it = root.getChildren(RBDatabase.NODE_POINTER).iterator();
            int count = 0;
            while (it.hasNext())
            {
                Element node = (Element)it.next();
                String id = node.getAttributeValue(RBDatabase.ID);
                
                AudioFileDescriptor fd = (AudioFileDescriptor)nodeMap.get(id);
                if (fd == null)
                {
                    System.out.println("Can't find node referece for ID=" + id);
                    System.out.println("Can't convert this playlist.... maybe it references files");
                    System.out.println("from another rhythmbox database?");
                    System.exit(1);
                }
                else
                {
                    writer.println(fd.getFileName());
                    ++count;
                }
            }
            writer.flush();
            writer.close();
            
            time = System.currentTimeMillis() - time;
            System.out.println("Read and converted " + intformat.format(count)
                + " playlist entries in "
                + numformat.format( ((double)time/(double)1000) ) + "s");
        }
        catch (Exception x)
        {
            x.printStackTrace();
            System.exit(1);
        }
    }
}