package com.protomatter.iriver;

import java.io.*;
import java.util.*;
import java.text.*;

import java.net.URL;

import com.protomatter.iriver.data.*;
//import com.protomatter.util.*;

import org.jdom.*;
import org.jdom.output.*;
import org.jdom.input.*;


public class ConvertRhythmboxDatabase
{
    private static DecimalFormat intformat = new DecimalFormat("###,###,###,##0");
    private static DecimalFormat numformat = new DecimalFormat("###,###,###,##0.00");
    
    public static void main(String args[])
    {
        if (args.length != 3)
        {
            System.out.println("Usage: ConvertRhythmboxDatabase rhythmboxdb basedir iriverdatabase");
            System.out.println("  Converts \"rhytmboxdb\" into \"iriverdatabase\"");
            System.out.println("  \"basedir\" should be the base directory of the iriver unit");
            System.exit(1);
        }
        
        String rbDatabase = args[0];
        String baseDir = args[1];
        String iriverDatabase = args[2];
        
        try
        {
            System.out.println("Parsing rhythmbox database " + rbDatabase);
            long time = System.currentTimeMillis();
            RBDatabase db = new RBDatabase(new File(rbDatabase), baseDir, true);
            List descriptors = db.getDescriptors();
            time = System.currentTimeMillis() - time;
            System.out.println("Loaded " + intformat.format(descriptors.size())
                + " files in "
                + numformat.format( ((double)time/(double)1000) ) + "s");
            
            File databaseFile = new File(iriverDatabase);
            DBUtil.writeDatabase(databaseFile, descriptors);

            System.out.println("Wrote " + numformat.format( ((double)databaseFile.length()/(double)1024) )
                + " KB to " + databaseFile);
        }
        catch (Exception x)
        {
            x.printStackTrace();
            System.exit(1);
        }
    }
}